/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex;

import frc.emul.api.persistence.IPersistentSection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PersistentSection implements IPersistentSection
{
    INVALID(0, "invalid"),
    ATTACHMENTS(33024, "attachments"),
    ATT_LOG_FILE(33025, "log-file"),
    ATT_CONF_FILE(33026, "config-file"),
    CPU(256, "cpu"),
    CPU_REGS(257, "registers"),
    CPU_CORE(258, "core"),
    VIA(512, "via"),
    LINES(768, "lines"),
    AUDIO(1024, "audio"),
    AUDIO_PSG(1040, "psg"),
    AUDIO_PSG_REGS(1041, "registers"),
    AUDIO_DAC(1056, "dac"),
    PERIPH(1280, "peripherals"),
    ANALOG(1536, "analog"),
    DISPLAY(1792, "display"),
    DISP_BUFF_WORK(1793, "work-buffer"),
    DISP_BUFF_ACTIVE(1794, "active-buffer"),
    MEMORY(2048, "memory"),
    MEM_RAM(2049, "ram"),
    MEM_ROM(2050, "rom"),
    MEM_CARTRIDGE(2051, "cartridge"),
    MEM_CARTRAM(2052, "onboard-ram"),
    MEM_BANK(2064, "bank"),
    MEM_BANK_SWITCH(2080, "bank-switching");

    private static final HashMap<Integer, PersistentSection> sections;
    private final String tag;
    private final int id;

    static {
        sections = new HashMap();
        PersistentSection[] persistentSectionArray = PersistentSection.values();
        int n = persistentSectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PersistentSection persistentSection = persistentSectionArray[n2];
            Integer n3 = new Integer(persistentSection.id);
            if (sections.get(n3) != null) {
                throw new RuntimeException("Collision for #" + n3 + ": " + sections.get(n3) + ", " + persistentSection);
            }
            sections.put(n3, persistentSection);
            ++n2;
        }
    }

    private PersistentSection(int n2, String string2) {
        this.id = n2;
        this.tag = string2;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public int getID() {
        return this.id;
    }

    public static PersistentSection getSection(int n) {
        return sections.get(n);
    }
}

